/* ============================================
   Scripts para la Escuela de Medicina Veterinaria
   ============================================ */

document.addEventListener('DOMContentLoaded', function() {

    // ==========================================
    // Funcionalidad de Tabs (ESCUELA, MISION, VISION)
    // ==========================================
    const tabButtons = document.querySelectorAll('.tab-button');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', function() {
            const targetTab = this.getAttribute('data-tab');

            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));

            // Add active class to clicked button and corresponding content
            this.classList.add('active');
            document.getElementById(targetTab).classList.add('active');
        });
    });

    // ==========================================
    // Funcionalidad del Menu Lateral de Carrera
    // ==========================================
    const sidebarLinks = document.querySelectorAll('.sidebar-link');
    const sectionContents = document.querySelectorAll('.carrera-section-content');

    sidebarLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            const targetSection = this.getAttribute('data-section');

            // Remove active class from all links and sections
            sidebarLinks.forEach(l => l.classList.remove('active'));
            sectionContents.forEach(section => section.classList.remove('active'));

            // Add active class to clicked link and corresponding section
            this.classList.add('active');
            document.getElementById(targetSection).classList.add('active');

            // Scroll suave hacia la seccion en movil
            if (window.innerWidth <= 992) {
                const carreraMain = document.querySelector('.carrera-main');
                if (carreraMain) {
                    carreraMain.scrollIntoView({ behavior: 'smooth', block: 'start' });
                }
            }
        });
    });

    // ==========================================
    // Animacion al hacer scroll
    // ==========================================
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('animate-in');
            }
        });
    }, observerOptions);

    // Observar elementos para animacion
    const animateElements = document.querySelectorAll('.info-card, .noticia-card, .tabs-wrapper');
    animateElements.forEach(el => {
        el.style.opacity = '0';
        el.style.transform = 'translateY(20px)';
        el.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
        observer.observe(el);
    });

    // Clase para elementos animados
    document.head.insertAdjacentHTML('beforeend', `
        <style>
            .animate-in {
                opacity: 1 !important;
                transform: translateY(0) !important;
            }
        </style>
    `);
});
